<?php
// https://platform.openai.com/settings/organization/billing/overview
function chatgpt_modelos($resultados) {
    $apiKey = 'sk-proj-kvvyogsKQBz5TPNolaBPT3BlbkFJpZqqIjpWzyZ0wyxgt85J';
    $url = 'https://api.openai.com/v1/chat/completions';

    // Limpiar el array, quitar backtest
    $resumen = [];
    foreach ($resultados as $modelo => $datos) {
        $tmp = $datos;
        unset($tmp["backtest"]);
        $resumen[$modelo] = $tmp;
    }

    // Armar contenido para enviar
    $pregunta = "Tengo los siguientes modelos de pronóstico con sus parámetros y métricas de error. Dame tus **top 3 modelos recomendados**, con una breve razón **en base a los valores que trae cada uno (MAPE, MAE, parámetros, etc.)**. 
    Evita explicaciones generales de las métricas. Di en qué casos o contextos cada modelo es bueno, según su forecast, errores y parámetros. También indicame en que caso no usarlo. 
    No incluyas conclusiones ni advertencias. Solo quiero tu ranking y justificación técnica por modelo. Aquí están los datos:\n\n" . json_encode($resumen, JSON_PRETTY_PRINT);
    $pregunta .= json_encode($resumen, JSON_PRETTY_PRINT);
    //echo $pregunta; die;    
    $data = array(
        'model' => 'gpt-4',
        'messages' => array(
            array(
                'role' => 'user',
                'content' => $pregunta
            )
        ),
        'temperature' => 0.3, // más conservador y analítico
        'max_tokens' => 500,
        'top_p' => 1,
        'frequency_penalty' => 0.2,
        'presence_penalty' => 0.3
    );


    // Enviar solicitud
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey
    ));

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error en cURL: ' . curl_error($ch);
    } else {
        $response_data = json_decode($response, true);
        if (isset($response_data['choices'][0]['message']['content'])) {
            echo "<br><pre style='white-space:pre-wrap;background:#f9f9f9;padding:10px;border-radius:6px;border:1px solid #ccc;'>";
            echo htmlspecialchars(trim($response_data['choices'][0]['message']['content']));
            echo "</pre><hr>";
        } else {
            echo 'No se pudo obtener respuesta de la API.';
        }
    }

    curl_close($ch);
}
